#define FILTERSCRIPT


// INCLUDES //
#include <a_samp>
#include <ZCMD>
#include <sscanf2>
#include <streamer>

// DEFINES //
#define COL_WHITE "{FFFFFF}"
#define COL_YELLOW "{F3FF02}"
#define COL_RED "{F81414}"
#define COL_BLUE "{0000FF}"

#define COLOR_BITEM 		0xE1B0B0FF
#define COLOR_GRAD1 		0xB4B5B7FF
#define COLOR_GRAD2 		0xBFC0C2FF
#define COLOR_GRAD3 		0xCBCCCEFF
#define COLOR_GRAD4 		0xD8D8D8FF
#define COLOR_GRAD5 		0xE3E3E3FF
#define COLOR_GRAD6 		0xF0F0F0FF
#define COLOR_GREY 			0xAFAFAFAA
#define COLOR_GREEN 		0x33AA33AA
#define COLOR_RED 			0xAA3333AA
#define COLOR_BLACK         0x000001FF
#define COLOR_BLUE 			0x007BD0FF
#define COLOR_LIGHTORANGE 	0xFFA100FF
#define COLOR_FLASH 		0xFF000080
#define COLOR_LIGHTRED 		0xFF6347AA
#define COLOR_LIGHTBLUE 	0x33CCFFAA
#define COLOR_LIGHTGREEN 	0x9ACD32AA
#define COLOR_YELLOW 		0xFFFF00AA
#define COLOR_LIGHTYELLOW	0xFFFF91FF
#define COLOR_YELLOW2 		0xF5DEB3AA
#define COLOR_WHITE 		0xFFFFFFAA
#define COLOR_FADE1 		0xE6E6E6E6
#define COLOR_FADE2 		0xC8C8C8C8
#define COLOR_FADE3 		0xAAAAAAAA
#define COLOR_FADE4 		0x8C8C8C8C
#define COLOR_FADE5 		0x6E6E6E6E
#define COLOR_PURPLE 		0xC2A2DAAA
#define COLOR_DBLUE 		0x2641FEAA
#define COLOR_DOC 			0xFF8282AA
#define COLOR_DCHAT 		0xF0CC00FF
#define COLOR_NEWS 			0xFFA500AA
#define COLOR_OOC 			0xE0FFFFAA
#define TEAM_BLUE_COLOR 	0x8D8DFF00
#define TEAM_GROVE_COLOR 	0x00AA00FF
#define TEAM_AZTECAS_COLOR 	0x01FCFFC8
#define NEWBIE_COLOR 		0x7DAEFFFF
#define SAMP_COLOR			0xAAC4E5FF
#define COLOR_FAMILY        0x00E6FFC8
#define COLOR_DEPARTMENT    0xFFB300C8
#define COLOR_RADIO         0x996892FF
#define COLOR_FBI           0xF097E2FF
#define COLOR_LSPD          0x041DFBC8
#define COLOR_ADMINCHAT     0xFFB300FF

// FORWARDS //
forward GiveRandomJob(playerid);
forward GiveDropOff(playerid);

// VARIABLES //
new bool:WantsJob[MAX_PLAYERS];
new bool:HasPilotJob[MAX_PLAYERS];
new bool:IsPlayerInJob[MAX_PLAYERS];
new PilotCars[8];
new Checkpoints[MAX_PLAYERS][8];
new bool:PilotJobs[MAX_PLAYERS][5];
new bool:WantsQuit[MAX_PLAYERS];
new LoadingTimer[MAX_PLAYERS];

// PICKUPS //
new jobpickup;


// STOCKS //
stock IsPilotCar(vehicleid)
{
	for(new veh = 0; veh < sizeof(PilotCars); veh++)
	{
	    if(vehicleid == PilotCars[veh]) return 1;
	}
	return 0;
}

stock GetName(playerid)
{
	new name[MAX_PLAYER_NAME];
	GetPlayerName(playerid, name, sizeof(name));
	return name;
}

// PUBLICS //
public GiveRandomJob(playerid)
{
    for(new q = 0; q < 8; q++) { Checkpoints[playerid][q] = -1; }
    for(new a = 0; a < 9; a++) { RemovePlayerMapIcon(playerid, a); }
    for(new i = 0; i < 5; i ++) { PilotJobs[playerid][i] = false; }
	IsPlayerInJob[playerid] = true;
	new rand = random(10);
	switch(rand)
	{
	    case 0 .. 2:
	    {
	        new rand2 = random(2), vtext[32], string[128];
	        if(rand2 == 0) { vtext = "Passengers"; }
	        else if(rand2 == 1) { vtext = "Cargo"; }
	        else if(rand2 == 2) { vtext = "Food"; }
	        Checkpoints[playerid][0] = CreateDynamicCP(1899.1376,-2354.3645,13.5469, 15.0, 0, 0, 0, 100.0);
	        SetPlayerMapIcon(playerid, 1, 1899.1376,-2354.3645,13.5469, 0, COLOR_RED, MAPICON_GLOBAL);
	        PilotJobs[playerid][0] = true;
	        format(string,sizeof(string),"* {FF0000}Pickup the {0000FF}%s {FF0000}at {00FF00}Los Santos Airport.", vtext);
	        SendClientMessage(playerid, COLOR_LIGHTRED, string);
		}
		case 3 .. 5:
		{
	        new rand2 = random(2), vtext[32], string[128];
	        if(rand2 == 0) { vtext = "Passengers"; }
	        else if(rand2 == 1) { vtext = "Cargo"; }
	        else if(rand2 == 2) { vtext = "Food"; }
	        Checkpoints[playerid][1] = CreateDynamicCP(-1224.5371,11.7382,14.1484, 15.0, 0, 0, 0, 100.0);
	        SetPlayerMapIcon(playerid, 2, -1224.5371,11.7382,14.1484, 0, COLOR_RED, MAPICON_GLOBAL);
	        PilotJobs[playerid][1] = true;
	        format(string,sizeof(string),"* {FF0000}Pickup the {0000FF}%s {FF0000}at {00FF00}San Fierro Airport.", vtext);
	        SendClientMessage(playerid, COLOR_LIGHTRED, string);
		}
		case  6 .. 8:
  		{
	        new rand2 = random(2), vtext[32], string[128];
	        if(rand2 == 0) { vtext = "Passengers"; }
	        else if(rand2 == 1) { vtext = "Cargo"; }
	        else if(rand2 == 2) { vtext = "Food"; }
	        Checkpoints[playerid][2] = CreateDynamicCP(365.3524,2537.1438,16.6648, 15.0, 0, 0, 0, 100.0);
	        SetPlayerMapIcon(playerid, 3, 365.3524,2537.1438,16.6648, 0, COLOR_RED, MAPICON_GLOBAL);
	        PilotJobs[playerid][2] = true;
	        format(string,sizeof(string),"* {FF0000}Pickup the {0000FF}%s {FF0000}at {00FF00}Abondant Airport.", vtext);
	        SendClientMessage(playerid, COLOR_LIGHTRED, string);
		}
		case 9 .. 10:
  		{
	        new rand2 = random(2), vtext[32], string[128];
	        if(rand2 == 0) { vtext = "Passengers"; }
	        else if(rand2 == 1) { vtext = "Cargo"; }
	        else if(rand2 == 2) { vtext = "Food"; }
	        Checkpoints[playerid][3] = CreateDynamicCP(1301.4873,1356.2103,10.8203, 15.0, 0, 0, 0, 100.0);
	        SetPlayerMapIcon(playerid, 4, 1301.4873,1356.2103,10.8203, 0, COLOR_RED, MAPICON_GLOBAL);
	        PilotJobs[playerid][3] = true;
	        format(string,sizeof(string),"* {FF0000}Pickup the {0000FF}%s {FF0000}at {00FF00}Las Venturas Airport.", vtext);
	        SendClientMessage(playerid, COLOR_LIGHTRED, string);
		}
	}
	return 1;
}

public GiveDropOff(playerid)
{
	KillTimer(LoadingTimer[playerid]);
	TogglePlayerControllable(playerid, true);
	DisablePlayerCheckpoint(playerid);
	for(new i = 0; i < 5; i ++) { PilotJobs[playerid][i] = false; }
	for(new a = 0; a < 9; a++) { RemovePlayerMapIcon(playerid, a); }
	for(new q = 0; q < 8; q++) { Checkpoints[playerid][q] = -1; }
	IsPlayerInJob[playerid] = false;
	new rand = random(10000), string[128];
	SendClientMessage(playerid, COLOR_YELLOW, "* BOSS: Well done pilot, here's your money.");
	format(string,sizeof(string),"* You've succesfully transported your transport, you recieve $%d from your boss.", rand);
	GivePlayerMoney(playerid, rand);
	SendClientMessage(playerid, COLOR_LIGHTBLUE, string);
	GameTextForPlayer(playerid, "~r~SUCCESFULLY TRANSPORTED", 3000, 3);
	return 1;
}

#if defined FILTERSCRIPT

public OnPlayerEnterDynamicCP(playerid, checkpointid)
{
	    if(checkpointid == Checkpoints[playerid][0] || checkpointid == Checkpoints[playerid][1] || checkpointid == Checkpoints[playerid][2] || checkpointid == Checkpoints[playerid][3])
	    {
	        for(new q = 0; q < 8; q++) { Checkpoints[playerid][q] = -1; }
	        for(new a = 0; a < 9; a++) { RemovePlayerMapIcon(playerid, a); }
	        DisablePlayerCheckpoint(playerid);
			new rand = random(10);
			switch(rand)
			{
			    case 0 .. 2:
			    {
			        new string[128];
			        Checkpoints[playerid][4] = CreateDynamicCP(1899.1376,-2354.3645,13.5469, 15.0, 0, 0, 0, 100.0);
			        SetPlayerMapIcon(playerid, 5, 1899.1376,-2354.3645,13.5469, 0, COLOR_RED, MAPICON_GLOBAL);
			        format(string,sizeof(string),"* {FF0000}Drop your {0000FF}transport {FF0000}off at {00FF00}Los Santos Airport.");
			        SendClientMessage(playerid, COLOR_LIGHTRED, string);
				}
				case 3 .. 5:
				{
				    new string[128];
				    for(new a = 0; a < 9; a++) { RemovePlayerMapIcon(playerid, a); }
			        Checkpoints[playerid][5] = CreateDynamicCP(-1224.5371,11.7382,14.1484, 15.0, 0, 0, 0, 100.0);
			        SetPlayerMapIcon(playerid, 6, -1224.5371,11.7382,14.1484, 0, COLOR_RED, MAPICON_GLOBAL);
			        format(string,sizeof(string),"* {FF0000}Drop your {0000FF}transport {FF0000}off at {00FF00}San Fierro Airport.");
			        SendClientMessage(playerid, COLOR_LIGHTRED, string);
				}
				case  6 .. 8:
		  		{
		  		    new string[128];
		  		    for(new a = 0; a < 9; a++) { RemovePlayerMapIcon(playerid, a); }
			        Checkpoints[playerid][6] = CreateDynamicCP(365.3524,2537.1438,16.6648, 15.0, 0, 0, 0, 100.0);
			        SetPlayerMapIcon(playerid, 7, 365.3524,2537.1438,16.6648, 0, COLOR_RED, MAPICON_GLOBAL);
			        format(string,sizeof(string),"* {FF0000}Drop your {0000FF}transport {FF0000}off at {00FF00}Abondant Airport.");
			        SendClientMessage(playerid, COLOR_LIGHTRED, string);
				}
				case 9 .. 10:
		  		{
		  		    new string[128];
		  		    for(new a = 0; a < 9; a++) { RemovePlayerMapIcon(playerid, a); }
			        Checkpoints[playerid][7] = CreateDynamicCP(1301.4873,1356.2103,10.8203, 15.0, 0, 0, 0, 100.0);
			        SetPlayerMapIcon(playerid, 8, 1301.4873,1356.2103,10.8203, 0, COLOR_RED, MAPICON_GLOBAL);
			        format(string,sizeof(string),"* {FF0000}Drop your {0000FF}transport {FF0000}off at {00FF00}Las Venturas Airport.");
			        SendClientMessage(playerid, COLOR_LIGHTRED, string);
				}
			}
		}
		else if(checkpointid == Checkpoints[playerid][4] || checkpointid == Checkpoints[playerid][5] || checkpointid == Checkpoints[playerid][6] || checkpointid == Checkpoints[playerid][7])
		{
		    TogglePlayerControllable(playerid, false);
		    for(new i = 0; i < 9; i++) { RemovePlayerMapIcon(playerid, i); }
			LoadingTimer[playerid] = SetTimerEx("GiveDropOff", 5000, 0, "d", playerid);
			GameTextForPlayer(playerid, "~w~UN~r~LOADING", 5000, 3);
		}
		return 1;
}

public OnFilterScriptInit()
{
	print("Pilot FS by Da Noob succesfully loaded.");
	
	// JOB PICKUP
	jobpickup = CreatePickup(1239, 1, 1958.3483,-2182.4187,13.5469);
	Create3DTextLabel("Type /join to become a pilot", COLOR_GREEN, 1958.3483,-2182.4187,13.5469, 10.0, 0, 0); // 3D TEXT LABEL FOR INFO
	
	// AIRPLANES
	PilotCars[0] = AddStaticVehicleEx(519,1889.6531,-2629.1267,14.4657,0,-1,-1,900); // Shamal 1
	PilotCars[1] = AddStaticVehicleEx(519,1823.1190,-2629.1267,14.4657,0,-1,-1,900); // Shamal 2
	PilotCars[2] = AddStaticVehicleEx(519,1754.5325,-2629.1267,14.4657,0,-1,-1,900); // Shamal 3
	PilotCars[3] = AddStaticVehicleEx(487,1964.2646,-2629.1267,13.7619,0,-1,-1,900); // Heli 1
	PilotCars[4] = AddStaticVehicleEx(487,1944.7985,-2629.1267,13.7354,0,-1,-1,900); // Heli 2
	PilotCars[5] = AddStaticVehicleEx(417,1765.6274,-2285.0801,26.8743,0,-1,-1,900); // Levi 1
	PilotCars[6] = AddStaticVehicleEx(593,1616.7531,-2627.9131,14.0094,0,-1,-1,900); // Dodo 1
	PilotCars[7] = AddStaticVehicleEx(593,1681.9587,-2627.9131,14.0094,0,-1,-1,900); // Dodo 2
	
	return 1;
}

public OnFilterScriptExit()
{
	return 1;
}

public OnPlayerRequestClass(playerid, classid)
{
	return 0;
}

public OnPlayerConnect(playerid)
{
	WantsJob[playerid] = false;
	HasPilotJob[playerid] = true; // TESTING PURPOSES - Needs to be set to FALSE
	IsPlayerInJob[playerid] = false;
	WantsQuit[playerid] = false;
	
	for(new i = 0; i < 5; i++) { PilotJobs[playerid][i] = false; }
	return 1;
}

public OnPlayerDisconnect(playerid, reason)
{
	return 1;
}

public OnPlayerSpawn(playerid)
{
	return 0;
}

public OnPlayerDeath(playerid, killerid, reason)
{
	return 1;
}

public OnVehicleSpawn(vehicleid)
{
	return 1;
}

public OnVehicleDeath(vehicleid, killerid)
{
	return 1;
}

public OnPlayerText(playerid, text[])
{
	return 1;
}

public OnPlayerCommandText(playerid, cmdtext[])
{
	if (strcmp("/mycommand", cmdtext, true, 10) == 0)
	{
		// Do something here
		return 1;
	}
	return 0;
}

public OnPlayerEnterVehicle(playerid, vehicleid, ispassenger)
{
	if(IsPilotCar(vehicleid))
	{
	    if(HasPilotJob[playerid] == true) {}
	    else
	    {
	        new Float:x, Float:y, Float:z;
	        GetPlayerPos(playerid, x, y, z);
	        SetPlayerPos(playerid, x, y, z);
	        SendClientMessage(playerid, COLOR_GREY, "You need to be a pilot to enter an airplane.");
		}
	}
	return 1;
}

public OnPlayerExitVehicle(playerid, vehicleid)
{
	if(HasPilotJob[playerid] == true)
	{
	    if(PilotJobs[playerid][0] == true || PilotJobs[playerid][1] == true || PilotJobs[playerid][2] == true || PilotJobs[playerid][3] == true)
	    {
	        for(new i = 0; i < 5; i++) { PilotJobs[playerid][i] = false; }
	        for(new a = 0; a < 9; a++) { RemovePlayerMapIcon(playerid, a); }
	        for(new q = 0; q < 9; q++) { Checkpoints[playerid][q] = -1; }
	        IsPlayerInJob[playerid] = false;
			SendClientMessage(playerid, COLOR_YELLOW, "* BOSS: Quiting before delivering? I'm taking that from your paycheck!");
			GivePlayerMoney(playerid, -1000);
			SendClientMessage(playerid, COLOR_LIGHTBLUE, "* Your Boss took 1000$ from your paycheck.");
		}
	}
	return 1;
}

public OnPlayerStateChange(playerid, newstate, oldstate)
{
	return 1;
}

public OnPlayerEnterCheckpoint(playerid)
{
	return 1;
}

public OnPlayerLeaveCheckpoint(playerid)
{
	return 1;
}

public OnPlayerEnterRaceCheckpoint(playerid)
{
	return 1;
}

public OnPlayerLeaveRaceCheckpoint(playerid)
{
	return 1;
}

public OnRconCommand(cmd[])
{
	return 1;
}

public OnPlayerRequestSpawn(playerid)
{
	return 1;
}

public OnObjectMoved(objectid)
{
	return 1;
}

public OnPlayerObjectMoved(playerid, objectid)
{
	return 1;
}

public OnPlayerPickUpPickup(playerid, pickupid)
{
	if(pickupid == jobpickup)
	{
	    GameTextForPlayer(playerid, "PILOT JOB", 3000, 3);
	}
	return 1;
}

public OnVehicleMod(playerid, vehicleid, componentid)
{
	return 1;
}

public OnVehiclePaintjob(playerid, vehicleid, paintjobid)
{
	return 1;
}

public OnVehicleRespray(playerid, vehicleid, color1, color2)
{
	return 1;
}

public OnPlayerSelectedMenuRow(playerid, row)
{
	return 1;
}

public OnPlayerExitedMenu(playerid)
{
	return 1;
}

public OnPlayerInteriorChange(playerid, newinteriorid, oldinteriorid)
{
	return 1;
}

public OnPlayerKeyStateChange(playerid, newkeys, oldkeys)
{
	return 1;
}

public OnRconLoginAttempt(ip[], password[], success)
{
	return 1;
}

public OnPlayerUpdate(playerid)
{
	return 1;
}

public OnPlayerStreamIn(playerid, forplayerid)
{
	return 1;
}

public OnPlayerStreamOut(playerid, forplayerid)
{
	return 1;
}

public OnVehicleStreamIn(vehicleid, forplayerid)
{
	return 1;
}

public OnVehicleStreamOut(vehicleid, forplayerid)
{
	return 1;
}

public OnDialogResponse(playerid, dialogid, response, listitem, inputtext[])
{
	return 1;
}

public OnPlayerClickPlayer(playerid, clickedplayerid, source)
{
	return 1;
}

CMD:join(playerid)
{
	if(IsPlayerInRangeOfPoint(playerid, 5.0, 1958.3483,-2182.4187,13.5469))
	{
	    if(HasPilotJob[playerid] == false)
	    {
	    	SendClientMessage(playerid, COLOR_LIGHTBLUE, "* You're about to become a Pilot, use /accept job to accept.");
	    	WantsJob[playerid] = true;
		}
		else
		{
		    SendClientMessage(playerid, COLOR_GRAD2, "You're already a pilot.");
		}
	}
	return 1;
}

CMD:accept(playerid, params[])
{
	new objective[32];
	if(sscanf(params,"s[32]", objective)) return SendClientMessage(playerid, COLOR_WHITE, "USAGE: /accept [job]");
	{
	    if(!strcmp(objective, "job", true))
	    {
	        if(WantsJob[playerid] == true)
	        {
	            SendClientMessage(playerid, COLOR_LIGHTBLUE, "* You're now a Pilot. Use /pilothelp to see your new commands.");
	            SetPlayerSkin(playerid, 61);
				HasPilotJob[playerid] = true;
			}
			else
			{
			    SendClientMessage(playerid, COLOR_GRAD2, "You don't want a job (believe me).");
			}
		}
		if(!strcmp(objective,"quit",true))
		{
		    if(WantsQuit[playerid] == true)
		    {
		        SendClientMessage(playerid, COLOR_LIGHTBLUE, "* You've quit your Pilot job.");
		        HasPilotJob[playerid] = false;
		        for(new i = 0; i < 5; i++) { PilotJobs[playerid][i] = false; }
		        DisablePlayerCheckpoint(playerid);
			}
			else
			{
			    SendClientMessage(playerid, COLOR_GRAD2, "You don't want to quit your job (believe me).");
			}
		}
	}
	return 1;
}

CMD:pilothelp(playerid)
{
	ShowPlayerDialog(playerid, 9852, DIALOG_STYLE_MSGBOX, "Pilot Help", "{FF0000} PILOT HELP\n\n{00FF00}/work {0000FF}-> {FFFFFF}Use this while in an airplane to start your work.\n{00FF00}/quitjob {0000FF}-> {FFFFFF}Quit your awesome pilot job.\n{00FF00}/accept [job/quit] {0000FF}-> {FFFFFF}Accept or quit your pilot job.\n{00FF00}/join {0000FF}-> {FFFFFF}When in Pilot pickup, you can join the Pilot job.\n{00FF00}/pilothelp {0000FF}-> {FFFFFF}Displays this dialog.", "Done", "");
	return 1;
}

CMD:work(playerid)
{
	new vehicleid = GetPlayerVehicleID(playerid);
	if(HasPilotJob[playerid] == false) return SendClientMessage(playerid, COLOR_GRAD2, "You're not a pilot.");
	if(IsPlayerInJob[playerid] == true) return SendClientMessage(playerid, COLOR_GRAD2, "Deliver your other transport first!");
	if(GetVehicleModel(vehicleid) != 519 && GetVehicleModel(vehicleid) != 487 && GetVehicleModel(vehicleid) != 417 && GetVehicleModel(vehicleid) != 593) return SendClientMessage(playerid, COLOR_GRAD2, "You're not in an airplane.");
	{
		GiveRandomJob(playerid);
	}
	return 1;
}

CMD:quitjob(playerid)
{
	if(HasPilotJob[playerid] == false) return SendClientMessage(playerid, COLOR_GRAD2, "You're not a pilot.");
	{
	    SendClientMessage(playerid, COLOR_LIGHTBLUE, "* You're about to quit your Pilot job, use /accept quit to quit.");
	    WantsQuit[playerid] = true;
	}
	return 1;
}

#endif
